(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      7862,        332]*)
(*NotebookOutlinePosition[      8702,        359]*)
(*  CellTagsIndexPosition[      8658,        355]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \( (*\ 
      To\ compute\ Gauss\ points\ x_i\ and\ the\ weights\ for\ Gauss\ 
          quadrature\ for\ \n\t\tn = 
        8\ for\ the\ interval\ \((\(-1\), \ 1)\)\ \ *) \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(LegendreP[8, x]\)], "Input"],

Cell[BoxData[
    \(35\/128 - \(315\ x\^2\)\/32 + \(3465\ x\^4\)\/64 - \(3003\ x\^6\)\/32 + 
      \(6435\ x\^8\)\/128\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(D[LegendreP[8, x], x]\)], "Input"],

Cell[BoxData[
    \(\(-\(\(315\ x\)\/16\)\) + \(3465\ x\^3\)\/16 - \(9009\ x\^5\)\/16 + 
      \(6435\ x\^7\)\/16\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(NSolve[LegendreP[8, x] == 0, \ x]\)], "Input"],

Cell[BoxData[
    \({{x \[Rule] \(-0.960289856497536931`\)}, {
        x \[Rule] \(-0.796666477413626239`\)}, {
        x \[Rule] \(-0.52553240991632899`\)}, {
        x \[Rule] \(-0.183434642495649811`\)}, {
        x \[Rule] 0.183434642495649811`}, {x \[Rule] 0.52553240991632899`}, {
        x \[Rule] 0.796666477413626239`}, {x \[Rule] 0.960289856497536931`}}
      \)], "Output"]
}, Open  ]],

Cell[BoxData[
    \( (*\ 
      These\ are\ the\ values\ of\ Gauss\ points\ x_i\ \nfor\ the\ interval\ 
        \((\(-1\), 1)\)\ \ *) \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(derivativeofp8[x_] := \n\t
      \(-\(\(315\ x\)\/16\)\) + \(3465\ x\^3\)\/16 - \(9009\ x\^5\)\/16 + 
        \(6435\ x\^7\)\/16; \nx1 = \(-0.960289856497536931`\); \n
    x2 = \(-0.796666477413626239`\); \nx3 = \(-0.52553240991632899`\); \n
    x4 = \(-0.183434642495649811`\); \nx5 = 0.183434642495649811`; \n
    x6 = 0.52553240991632899`; \nx7 = 0.796666477413626239`; \n
    x8 = 0.960289856497536931`; \n
    w1 = 2/\((\ \((1 - x1^2)\) \((derivativeofp8[x1])\)^2)\)\)], "Input"],

Cell[BoxData[
    \(0.101228536290374893`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(w2 = 2/\((\ \((1 - x2^2)\) \((derivativeofp8[x2])\)^2)\)\)], "Input"],

Cell[BoxData[
    \(0.222381034453378623`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(w3 = 2/\((\ \((1 - x3^2)\) \((derivativeofp8[x3])\)^2)\)\)], "Input"],

Cell[BoxData[
    \(0.31370664587788748`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(w4 = 2/\((\ \((1 - x4^2)\) \((derivativeofp8[x4])\)^2)\)\)], "Input"],

Cell[BoxData[
    \(0.362683783378361912`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(w5 = 2/\((\ \((1 - x5^2)\) \((derivativeofp8[x5])\)^2)\)\)], "Input"],

Cell[BoxData[
    \(0.362683783378361912`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(w6 = 2/\((\ \((1 - x6^2)\) \((derivativeofp8[x6])\)^2)\)\)], "Input"],

Cell[BoxData[
    \(0.31370664587788748`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(w7 = 2/\((\ \((1 - x7^2)\) \((derivativeofp8[x7])\)^2)\)\)], "Input"],

Cell[BoxData[
    \(0.222381034453378623`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(w8 = 2/\((\ \((1 - x8^2)\) \((derivativeofp8[x8])\)^2)\)\)], "Input"],

Cell[BoxData[
    \(0.101228536290374893`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \( (*\ 
      These\ are\ the\ weights\ for\ the\ interval\ \((\(-1\), 1)\)\ \ *) 
      \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ 
      Now\ to\ obtain\ the\ Gausspoints\ \[Xi]_i\ for\ the\ interval\ 
        \((0, \[Pi])\), \ 
      use\ the\ formula\ \[Xi]_i = \[Pi] \((1 + x_i)\)/2\ \ *) \n\n
    \[Xi]1 = \[Pi] \((1 + x1)\)/2\ \)\)], "Input"],

Cell[BoxData[
    \(0.0623765475501671851`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\[Xi]2 = \[Pi] \((1 + x2)\)/2\ \)\)], "Input"],

Cell[BoxData[
    \(0.319395550392942961`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\[Xi]3 = \[Pi] \((1 + x3)\)/2\ \)\)], "Input"],

Cell[BoxData[
    \(0.745291947686657074`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\[Xi]4 = \[Pi] \((1 + x4)\)/2\ \)\)], "Input"],

Cell[BoxData[
    \(1.28265786415579485`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\[Xi]5 = \[Pi] \((1 + x5)\)/2\ \)\)], "Input"],

Cell[BoxData[
    \(1.85893478943399852`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\[Xi]6 = \[Pi] \((1 + x6)\)/2\ \)\)], "Input"],

Cell[BoxData[
    \(2.39630070590313604`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\[Xi]7 = \[Pi] \((1 + x7)\)/2\ \)\)], "Input"],

Cell[BoxData[
    \(2.82219710319685024`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\[Xi]8 = \[Pi] \((1 + x8)\)/2\ \)\)], "Input"],

Cell[BoxData[
    \(3.07921610603962569`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \( (*\ 
      These\ are\ the\ values\ of\ \[Xi]_i\ in\ radians . \n\t\t\tNow\ their\ 
        values\ in\ degrees\ \(are : \)\ \ *) \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\[Xi]1 = 90*\((1 + x1)\)\ \)\)], "Input"],

Cell[BoxData[
    \(3.57391291522167442`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Xi]2 = 90*\((1 + x2)\)\)], "Input"],

Cell[BoxData[
    \(18.3000170327736348`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Xi]3 = 90*\((1 + x3)\)\)], "Input"],

Cell[BoxData[
    \(42.7020831075303952`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Xi]4 = 90*\((1 + x4)\)\)], "Input"],

Cell[BoxData[
    \(73.4908821753915209`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Xi]5 = 90*\((1 + x5)\)\)], "Input"],

Cell[BoxData[
    \(106.509117824608479`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Xi]6 = 90*\((1 + x6)\)\)], "Input"],

Cell[BoxData[
    \(137.297916892469595`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Xi]7 = 90*\((1 + x7)\)\)], "Input"],

Cell[BoxData[
    \(161.699982967226363`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Xi]8 = 90*\((1 + x8)\)\)], "Input"],

Cell[BoxData[
    \(176.426087084778293`\)], "Output"]
}, Open  ]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{520, 509},
WindowMargins->{{12, Automatic}, {Automatic, 13}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 203, 4, 59, "Input"],

Cell[CellGroupData[{
Cell[1937, 57, 48, 1, 27, "Input"],
Cell[1988, 60, 132, 2, 44, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2157, 67, 54, 1, 27, "Input"],
Cell[2214, 70, 127, 2, 44, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2378, 77, 66, 1, 27, "Input"],
Cell[2447, 80, 384, 7, 56, "Output"]
}, Open  ]],
Cell[2846, 90, 147, 3, 43, "Input"],

Cell[CellGroupData[{
Cell[3018, 97, 504, 8, 209, "Input"],
Cell[3525, 107, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3617, 113, 89, 1, 27, "Input"],
Cell[3709, 116, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3801, 122, 89, 1, 27, "Input"],
Cell[3893, 125, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3984, 131, 89, 1, 27, "Input"],
Cell[4076, 134, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4168, 140, 89, 1, 27, "Input"],
Cell[4260, 143, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4352, 149, 89, 1, 27, "Input"],
Cell[4444, 152, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4535, 158, 89, 1, 27, "Input"],
Cell[4627, 161, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4719, 167, 89, 1, 27, "Input"],
Cell[4811, 170, 55, 1, 26, "Output"]
}, Open  ]],
Cell[4881, 174, 120, 3, 27, "Input"],

Cell[CellGroupData[{
Cell[5026, 181, 244, 5, 91, "Input"],
Cell[5273, 188, 56, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5366, 194, 68, 1, 27, "Input"],
Cell[5437, 197, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5529, 203, 68, 1, 27, "Input"],
Cell[5600, 206, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5692, 212, 68, 1, 27, "Input"],
Cell[5763, 215, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5854, 221, 68, 1, 27, "Input"],
Cell[5925, 224, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6016, 230, 68, 1, 27, "Input"],
Cell[6087, 233, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6178, 239, 68, 1, 27, "Input"],
Cell[6249, 242, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6340, 248, 68, 1, 27, "Input"],
Cell[6411, 251, 54, 1, 26, "Output"]
}, Open  ]],
Cell[6480, 255, 164, 3, 43, "Input"],

Cell[CellGroupData[{
Cell[6669, 262, 63, 1, 27, "Input"],
Cell[6735, 265, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6826, 271, 57, 1, 27, "Input"],
Cell[6886, 274, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6977, 280, 57, 1, 27, "Input"],
Cell[7037, 283, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7128, 289, 57, 1, 27, "Input"],
Cell[7188, 292, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7279, 298, 57, 1, 27, "Input"],
Cell[7339, 301, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7430, 307, 57, 1, 27, "Input"],
Cell[7490, 310, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7581, 316, 57, 1, 27, "Input"],
Cell[7641, 319, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7732, 325, 57, 1, 27, "Input"],
Cell[7792, 328, 54, 1, 26, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

